//  Copyright (C) 2001  MandrakeSoft S.A.
//
//    MandrakeSoft S.A.
//    43, rue d'Aboukir
//    75002 Paris - France
//    http://www.linux-mandrake.com/
//    http://www.mandrakesoft.com/
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA








#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR





  void
BX_CPU_C::BOUND_GvMa(BxInstruction_t *i)
{
#if BX_CPU_LEVEL < 2
  BX_PANIC(("BOUND_GvMa: not supported on 8086!\n"));
#else

  if (i->mod == 0xc0) {
    /* undefined opcode exception */
    BX_PANIC(("bound: op2 must be mem ref\n"));
    UndefinedOpcode(i);
    }

  if (i->os_32) {
    Bit32s bound_min, bound_max;
    Bit32s op1_32;

    op1_32 = BX_READ_32BIT_REG(i->nnn);

    read_virtual_dword(i->seg, i->rm_addr, (Bit32u *) &bound_min);
    read_virtual_dword(i->seg, i->rm_addr+4, (Bit32u *) &bound_max);

    /* ??? */
    if ( (op1_32 < bound_min) || (op1_32 > bound_max) ) {
      BX_INFO(("BOUND: fails bounds test\n"));
      exception(5, 0, 0);
      }
    }
  else {
    Bit16s bound_min, bound_max;
    Bit16s op1_16;

    op1_16 = BX_READ_16BIT_REG(i->nnn);

    read_virtual_word(i->seg, i->rm_addr, (Bit16u *) &bound_min);
    read_virtual_word(i->seg, i->rm_addr+2, (Bit16u *) &bound_max);

    /* ??? */
    if ( (op1_16 < bound_min) || (op1_16 > bound_max) ) {
      BX_INFO(("BOUND: fails bounds test\n"));
      exception(5, 0, 0);
      }
    }

#endif
}

  void
BX_CPU_C::INT1(BxInstruction_t *i)
{
  // This is an undocumented instrucion (opcode 0xf1)
  // which is useful for an ICE system.

#if BX_DEBUGGER
  BX_CPU_THIS_PTR show_flag |= Flag_int;
#endif

#if BX_EMULATION_TOWNS
  if(exec_bioshook(HOOK_SINT,1,0)) return;
#endif
  interrupt(1, 1, 0, 0);
  BX_INSTR_FAR_BRANCH(BX_INSTR_IS_INT,
                      BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].selector.value,
                      BX_CPU_THIS_PTR eip);
}

  void
BX_CPU_C::INT3(BxInstruction_t *i)
{
  Bit32u new_linear_addr;
  Bit32u new_phy_addr;
  Bit32u temp_eip, temp_limit;

  // INT 3 is not IOPL sensitive

#if BX_DEBUGGER
  BX_CPU_THIS_PTR show_flag |= Flag_int;
#endif

//BX_PANIC(("INT3: bailing\n"));
#if BX_EMULATION_TOWNS
  // cs:eIP
  // prefetch QSIZE byte quantity aligned on corresponding boundary
  temp_eip   = BX_CPU_THIS_PTR prev_eip;
  temp_limit = BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled;

  new_linear_addr = BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.base + temp_eip;
  if (temp_eip > temp_limit) {
    BX_PANIC(("prefetch: EIP > CS.limit\n"));
    }

  if (BX_CPU_THIS_PTR cr0.pg) {
    // aligned block guaranteed to be all in one page, same A20 address
    new_phy_addr = itranslate_linear(new_linear_addr, CPL==3);
    new_phy_addr = A20ADDR(new_phy_addr);
    }
  else {
    new_phy_addr = A20ADDR(new_linear_addr);
    }
  BX_INFO(("INT3:%.8x\n",new_phy_addr));
  if((!bx_mem.MAIN_MEM &&
      (new_phy_addr & 0xffff8000) == 0x000f8000) ||
     (new_phy_addr & 0xfffc0000) == 0xfffc0000) {
    if(exec_bioshook(HOOK_ROM,new_phy_addr & 0x3ffff,0)) return;
    if(bx_mem.sysrom[new_phy_addr & 0x3ffff] == 0xcc) {
      BX_PANIC(("cpu:illegal system ROM call to %.8x\n",new_phy_addr));
    } else {
      BX_CPU_THIS_PTR fetch_ptr = &bx_mem.sysrom[new_phy_addr & 0x3ffff];
      BX_CPU_THIS_PTR bytesleft = 1;
      EIP = BX_CPU_THIS_PTR prev_eip;
      ESP = BX_CPU_THIS_PTR prev_esp;
      return;
    }
  }
  if(new_phy_addr < bx_mem.len) {
    if(exec_bioshook(HOOK_RAM,new_phy_addr,0)) return;
  }
  if(exec_bioshook(HOOK_SINT,3,0)) return;
#endif
  interrupt(3, 1, 0, 0);
  BX_INSTR_FAR_BRANCH(BX_INSTR_IS_INT,
                      BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].selector.value,
                      BX_CPU_THIS_PTR eip);
}


  void
BX_CPU_C::INT_Ib(BxInstruction_t *i)
{
  Bit8u imm8;

#if BX_DEBUGGER
  BX_CPU_THIS_PTR show_flag |= Flag_int;
#endif

  imm8 = i->Ib;

  if (v8086_mode() && (IOPL<3)) {
    //BX_INFO(("int_ib: v8086: IOPL<3\n"));
    exception(BX_GP_EXCEPTION, 0, 0);
    }

#ifdef SHOW_EXIT_STATUS
if ( (imm8 == 0x21) && (AH == 0x4c) ) {
  BX_INFO(("INT 21/4C called AL=0x%02x, BX=0x%04x\n", (unsigned) AL, (unsigned) BX));
  }
#endif

#if BX_EMULATION_TOWNS
  if(exec_bioshook(HOOK_SINT,imm8,0)) return;
#endif
  interrupt(imm8, 1, 0, 0);
  BX_INSTR_FAR_BRANCH(BX_INSTR_IS_INT,
                      BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].selector.value,
                      BX_CPU_THIS_PTR eip);
}


  void
BX_CPU_C::INTO(BxInstruction_t *i)
{

#if BX_DEBUGGER
  BX_CPU_THIS_PTR show_flag |= Flag_int;
#endif

  /* ??? is this IOPL sensitive ? */
  if (v8086_mode()) BX_PANIC(("soft_int: v8086 mode unsupported\n"));

  if (get_OF()) {
#if BX_EMULATION_TOWNS
    if(exec_bioshook(HOOK_SINT,4,0)) return;
#endif
    interrupt(4, 1, 0, 0);
    BX_INSTR_FAR_BRANCH(BX_INSTR_IS_INT,
                        BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].selector.value,
                        BX_CPU_THIS_PTR eip);
    }
}
